<?php

if ( ! function_exists( 'dashed_slug_activation_admin_init' ) ) {

	function dashed_slug_activation_admin_init() {

		add_settings_section(
			'ds_activation_section',
			'dashed-slug activation',
			'dashed_slug_activation_section',
			'ds_activation_page' );

		register_setting( 'ds_activation_page', 'ds-activation-code' );

		add_settings_field(
			'ds-activation-code',
			'dashed-slug activation code',
			'dashed_slug_activation_code',
			'ds_activation_page',
			'ds_activation_section' );
	}

	add_action( 'admin_init', 'dashed_slug_activation_admin_init' );
}


if ( ! function_exists( 'dashed_slug_activation_page_menu' ) ) {
	function dashed_slug_activation_page_menu() {

		if ( current_user_can( 'manage_options' ) ) {
			add_options_page(
				'Activate dashed-slug',
				'Activate dashed-slug.net plugins',
				'manage_options',
				'ds_activation_page',
				'dashed_slug_activation_page' );
		}
	}

	add_action( 'admin_menu', 'dashed_slug_activation_page_menu' );
}


if ( ! function_exists( 'dashed_slug_activation_page' ) ) {
	function dashed_slug_activation_page() {

		echo '<form method="post" action="options.php">';
		settings_fields( 'ds_activation_page' );
		do_settings_sections( 'ds_activation_page' );
		submit_button();
		echo '</form>';

	}
}

if ( ! function_exists( 'dashed_slug_activation_section' ) ) {
	function dashed_slug_activation_section() {
		echo '<p style="text-size: smaller">' .
			__( 'Activate updates to the dashed-slug.net plugins', 'slate' ) .
			'</p>';
	}
}

if ( ! function_exists( 'dashed_slug_activation_code' ) ) {
	function dashed_slug_activation_code( $args ) {
		echo '<input name="ds-activation-code" id="ds-activation-code" type="text" value="'
			. esc_attr( get_option( 'ds-activation-code' ) ) . '"/>';

		echo '<p>' .
			__( 'Enter here your dashed-slug.net activation code, exactly as you received it in your e-mail.', 'slate' ) .
			'</p>';
	}
}

if ( ! function_exists( 'dashed_slug_notify_missing_code') ) {
	function dashed_slug_notify_missing_code() {
		if ( ! get_option( 'ds-activation-code' ) ) {

			?><div class="notice notice-error is-dismissible">
				<h2><?php echo 'dashed-slug.net notice'; ?></h2>
				<p>Thank you for installing a premium <a href="http://dashed-slug.net">dashed-slug</a> plugin.</p>
				<p>To enable updates for all the premium <em>dashed-slug</em> plugins, please visit the
				<a href="<?php echo get_admin_url( null, 'options-general.php?page=ds_activation_page' ); ?>">activation page</a>
				and enter the activation code that you have been sent in your e-mail.</p>
				<p>Contact <a href="mailto:info@dashed-slug.net">info@dashed-slug.net</a>
				for any questions/problems with activation.</p>
			</div><?php
		}
	}

	add_action( 'admin_notices', 'dashed_slug_notify_missing_code' );
}

function slate_vc_get_update_json( $plugin_slug ) {

	$user_nonce = get_option( 'ds-activation-code' );

	if ( $user_nonce ) {

		$json_url = "https://www.dashed-slug.net/plugin-update/$plugin_slug/$user_nonce";
		$url_hash = 'ds_update_' . md5( $json_url );
		$cached_result = get_transient( $url_hash );

		if ( false === $cached_result ) {
			$update_json = wp_remote_get( $json_url );
			set_transient( $url_hash, $update_json, 4 * HOUR_IN_SECONDS );
		} else {
			$update_json = $cached_result;
		}

		if ( is_array( $update_json ) && isset( $update_json['response'] )  && isset( $update_json['response']['code'] ) ) {

			if ( 200 == $update_json['response']['code'] ) {

				$update_info = json_decode( $update_json['body'] );
				if ( isset( $update_info->sections ) ) {
					$update_info->sections = (array) $update_info->sections;
				}

				if ( ! is_null( $update_info ) ) {
					return $update_info;
				}

			}
		}
	}

	return false;
}

if ( ! function_exists( 'slate_vc_pre_set_site_transient_update_plugins' ) ) {
	function slate_vc_pre_set_site_transient_update_plugins( $transient ) {


 		$plugin_slug = 'slate-vc';
 		$plugin = "$plugin_slug/$plugin_slug.php";

 		$update_info = slate_vc_get_update_json( $plugin_slug );

		if ( is_object( $update_info )
			&& isset( $update_info->new_version )
			&& version_compare(
				'1.0.1',
				$update_info->new_version,
				'<' ) ) {

			if ( ! isset( $transient->response[ $plugin ] ) ) {
				$transient->response[ $plugin ] = $update_info;
			}
		}

		return $transient;

	}
}

add_filter( 'pre_set_site_transient_update_plugins', 'slate_vc_pre_set_site_transient_update_plugins' );

function slate_vc_plugins_api($def, $action, $args) {

	$plugin_slug = 'slate-vc';

	if ( isset( $args->slug) && $args->slug == $plugin_slug && 'plugin_information' == $action ) {
		return slate_vc_get_update_json( $plugin_slug );
	}

	return $def;

}

add_filter('plugins_api', 'slate_vc_plugins_api', 10, 3);

