# Localization

## Basic concepts

The plugin has been internationalized. All strings use the `__()` function and its friends.

To familiarize yourself with some basic localization concepts, you can read [this page in the Codex][wp-l10n].

## Text domains {#text-domains}

The parent plugin uses a single *[text domain][glossary-text-domains]* since version `6.0.0`. The domain is `wallets`. There is no `wallets-front` domain any more. This allows translation contributions from https://translate.wordpess.org to be used.

For the extensions to the plugin, the localized strings have been split into two *[text domains][glossary-text-domains]*. The domains are named `wallets` and `wallets-front`. This allows you to easily localize the frontend without localizing the backend (WordPress admin interface). The frontend requires considerably less effort to localize than the entire plugin.


## Translating a plugin extension to your language

1. Copy the `.pot` file to a `.po` file that includes the [ISO 639-1][639-1] language code you want to translate. For example, to translate the frontend to Spanish, copy `wallets-front.pot` to `wallets-front-es.po`. For a list of language codes available, consult the [gettext documentation][lang-codes].

2. Edit the `.po` file and translate the strings to your language. You can use any text editor to do this, but you may find it easier if you use [POEdit][poedit].

3. Save the `.po` file and convert it to a machine-readable `.mo` file. If you use [POEdit][poedit] there is an option to compile to `.mo`. Place both files in the `wp-content/plugins/wallets/languages` directory.

4. That's it. To test your translation, go to your WordPress admin screens, and to _Settings_ &rarr; _General_ &rarr; _Site Language_. Select your language and click on _Save Changes_.

## Donating translations

If you have produced a translation for a language that is not already available, and you wish to donate it to the project, you can email it to [info@dashed-slug.net][email]. It will be much appreciated!


[639-1]: https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes
[email]: mailto:info@dashed-slug.net
[lang-codes]: https://www.gnu.org/software/gettext/manual/gettext.html#Language-Codes
[poedit]: https://poedit.net/
[wp-l10n]: https://developer.wordpress.org/plugins/internationalization/localization/
