/*=============================================================================
	Author:			Eric M. Barnard - @ericmbarnard								
	License:		MIT (http://opensource.org/licenses/mit-license.php)		
																				
	Description:	Validation Library for KnockoutJS							
	Version:		2.0.4											
===============================================================================
*/

!function(e){"function"==typeof require&&"object"==typeof exports&&"object"==typeof module?e(require("knockout"),exports):"function"==typeof define&&define.amd?define(["knockout","exports"],e):e(ko,ko.validation={})}(function(f,e){if(void 0===f)throw new Error("Knockout is required, please ensure it is loaded before loading this validation plug-in");f.validation=e;var t,i,a,c=f.validation,o=f.utils,p=o.unwrapObservable,n=o.arrayForEach,u=o.extend,r={registerExtenders:!0,messagesOnModified:!0,errorsAsTitle:!0,errorsAsTitleOnModified:!1,messageTemplate:null,insertMessages:!0,parseInputAttributes:!1,writeInputAttributes:!1,decorateInputElement:!1,decorateElementOnModified:!0,errorClass:null,errorElementClass:"validationElement",errorMessageClass:"validationMessage",allowHtmlMessages:!1,grouping:{deep:!1,observable:!0,live:!1},validate:{}},s=u({},r);s.html5Attributes=["required","pattern","min","max","step"],s.html5InputTypes=["email","number","date"],s.reset=function(){u(s,r)},c.configuration=s,c.utils=(t=(new Date).getTime(),i={},a="__ko_validation__",{isArray:function(e){return e.isArray||"[object Array]"===Object.prototype.toString.call(e)},isObject:function(e){return null!==e&&"object"==typeof e},isNumber:function(e){return!isNaN(e)},isObservableArray:function(e){return!!e&&"function"==typeof e.remove&&"function"==typeof e.removeAll&&"function"==typeof e.destroy&&"function"==typeof e.destroyAll&&"function"==typeof e.indexOf&&"function"==typeof e.replace},values:function(e){var t=[];for(var r in e)e.hasOwnProperty(r)&&t.push(e[r]);return t},getValue:function(e){return"function"==typeof e?e():e},hasAttribute:function(e,t){return null!==e.getAttribute(t)},getAttribute:function(e,t){return e.getAttribute(t)},setAttribute:function(e,t,r){return e.setAttribute(t,r)},isValidatable:function(e){return!!(e&&e.rules&&e.isValid&&e.isModified)},insertAfter:function(e,t){e.parentNode.insertBefore(t,e.nextSibling)},newId:function(){return t+=1},getConfigOptions:function(e){return c.utils.contextFor(e)||c.configuration},setDomData:function(e,t){var r=e[a];r||(e[a]=r=c.utils.newId()),i[r]=t},getDomData:function(e){var t=e[a];if(t)return i[t]},contextFor:function(e){switch(e.nodeType){case 1:case 8:var t=c.utils.getDomData(e);if(t)return t;if(e.parentNode)return c.utils.contextFor(e.parentNode)}},isEmptyVal:function(e){return null==e||""===e},getOriginalElementTitle:function(e){var t=c.utils.getAttribute(e,"data-orig-title"),r=e.title;return c.utils.hasAttribute(e,"data-orig-title")?t:r},async:function(e){window.setImmediate?window.setImmediate(e):window.setTimeout(e,0)},forEach:function(e,t){if(c.utils.isArray(e))return n(e,t);for(var r in e)e.hasOwnProperty(r)&&t(e[r],r)}});var l,d,v,g=(l=0,d=c.configuration,v=c.utils,{init:function(e,t){0<l&&!t||((e=e||{}).errorElementClass=e.errorElementClass||e.errorClass||d.errorElementClass,e.errorMessageClass=e.errorMessageClass||e.errorClass||d.errorMessageClass,u(d,e),d.registerExtenders&&c.registerExtenders(),l=1)},reset:c.configuration.reset,group:function(t,r){var i={options:r=u(u({},d.grouping),r),graphMonitor:f.observable(),flagged:[],subscriptions:[],validatables:[]},a=null;return(a=r.observable?f.computed(function(){return i.graphMonitor(),b(t,i),F(i.validatables)}):function(){return b(t,i),F(i.validatables)}).showAllMessages=function(t){void 0===t&&(t=!0),a.forEach(function(e){v.isValidatable(e)&&e.isModified(t)})},a.isAnyMessageShown=function(){return!!a.find(function(e){return v.isValidatable(e)&&!e.isValid()&&e.isModified()})},a.filter=function(e){return e=e||function(){return!0},a(),o.arrayFilter(i.validatables,e)},a.find=function(e){return e=e||function(){return!0},a(),o.arrayFirst(i.validatables,e)},a.forEach=function(e){e=e||function(){},a(),n(i.validatables,e)},a.map=function(e){return e=e||function(e){return e},a(),o.arrayMap(i.validatables,e)},a._updateState=function(e){if(!v.isObject(e))throw new Error("An object is required.");if(t=e,!r.observable)return b(e,i),F(i.validatables);i.graphMonitor.valueHasMutated()},a},formatMessage:function(e,t,r){if(v.isObject(t)&&t.typeAttr&&(t=t.value),"function"==typeof e)return e(t,r);var i=p(t);return null==i&&(i=[]),v.isArray(i)||(i=[i]),e.replace(/{(\d+)}/gi,function(e,t){return void 0!==i[t]?i[t]:e})},addRule:function(e,t){return e.extend({validatable:!0}),o.arrayFirst(e.rules(),function(e){return e.rule&&e.rule===t.rule})||e.rules.push(t),e},addAnonymousRule:function(e,t){void 0===t.message&&(t.message="Error"),t.onlyIf&&(t.condition=t.onlyIf),c.addRule(e,t)},addExtender:function(r){f.extenders[r]=function(e,t){return t&&(t.message||t.onlyIf)?c.addRule(e,{rule:r,message:t.message,params:!!v.isEmptyVal(t.params)||t.params,condition:t.onlyIf}):c.addRule(e,{rule:r,params:t})}},registerExtenders:function(){if(d.registerExtenders)for(var e in c.rules)c.rules.hasOwnProperty(e)&&(f.extenders[e]||c.addExtender(e))},insertValidationMessage:function(e){var t=document.createElement("SPAN");return t.className=v.getConfigOptions(e).errorMessageClass,v.insertAfter(e,t),t},parseInputValidationAttributes:function(i,a){n(c.configuration.html5Attributes,function(e){if(v.hasAttribute(i,e)){var t=i.getAttribute(e)||!0;if("min"===e||"max"===e){var r=i.getAttribute("type");void 0!==r&&r||(r="text"),t={typeAttr:r,value:t}}c.addRule(a(),{rule:e,params:t})}});var t=i.getAttribute("type");n(c.configuration.html5InputTypes,function(e){e===t&&c.addRule(a(),{rule:"date"===e?"dateISO":e,params:!0})})},writeInputValidationAttributes:function(i,e){var t=e();if(t&&t.rules){var a=t.rules();n(c.configuration.html5Attributes,function(t){var r=o.arrayFirst(a,function(e){return e.rule&&e.rule.toLowerCase()===t.toLowerCase()});r&&f.computed({read:function(){var e=f.unwrap(r.params);"pattern"===r.rule&&e instanceof RegExp&&(e=e.source),i.setAttribute(t,e)},disposeWhenNodeIsRemoved:i})}),a=null}},makeBindingHandlerValidatable:function(e){var n=f.bindingHandlers[e].init;f.bindingHandlers[e].init=function(e,t,r,i,a){return n(e,t,r,i,a),f.bindingHandlers.validationCore.init(e,t,r,i,a)}},setRules:function(e,t){var d=function(e,t){if(e&&t)for(var r in t)if(t.hasOwnProperty(r)){var i=t[r];if(e[r]){var a=e[r],n=p(a),s={},u={};for(var l in i)i.hasOwnProperty(l)&&(c.rules[l]?s[l]=i[l]:u[l]=i[l]);if(f.isObservable(a)&&a.extend(s),n&&v.isArray(n))for(var o=0;o<n.length;o++)d(n[o],u);else d(n,u)}}};d(e,t)}});function m(e){n(e.subscriptions,function(e){e.dispose()}),e.subscriptions=[]}function b(e,t){t.validatables=[],m(t),function t(e,r,i){var a=[],n=e.peek?e.peek():e;!0!==e.__kv_traversed&&(r.options.deep&&(e.__kv_traversed=!0,r.flagged.push(e)),i=void 0!==i?i:r.options.deep?1:-1,f.isObservable(e)&&(e.errors||v.isValidatable(e)||e.extend({validatable:!0}),r.validatables.push(e),r.options.live&&v.isObservableArray(e)&&r.subscriptions.push(e.subscribe(function(){r.graphMonitor.valueHasMutated()}))),n&&!n._destroy&&(v.isArray(n)?a=n:v.isObject(n)&&(a=v.values(n))),0!==i&&v.forEach(a,function(e){!e||e.nodeType||f.isComputed(e)&&!e.rules||t(e,r,i+1)}))}(e,t),function(e){e.options.deep&&(n(e.flagged,function(e){delete e.__kv_traversed}),e.flagged.length=0),e.options.live||m(e)}(t)}function F(e){var t=[];return n(e,function(e){v.isValidatable(e)&&!e.isValid()&&t.push(e.error.peek())}),t}function y(u){var l="max"===u;return function(e,t){if(c.utils.isEmptyVal(e))return!0;var r,i,a,n,s;switch(r=void 0===t.typeAttr?(i="text",t):(i=t.typeAttr,t.value),isNaN(r)||r instanceof Date||(i="number"),i.toLowerCase()){case"week":if(a=/^(\d{4})-W(\d{2})$/,null===(n=e.match(a)))throw new Error("Invalid value for "+u+" attribute for week input.  Should look like '2000-W33' http://www.w3.org/TR/html-markup/input.week.html#input.week.attrs.min");return!!(s=r.match(a))&&(l?n[1]<s[1]||n[1]===s[1]&&n[2]<=s[2]:n[1]>s[1]||n[1]===s[1]&&n[2]>=s[2]);case"month":if(a=/^(\d{4})-(\d{2})$/,null===(n=e.match(a)))throw new Error("Invalid value for "+u+" attribute for month input.  Should look like '2000-03' http://www.w3.org/TR/html-markup/input.month.html#input.month.attrs.min");return!!(s=r.match(a))&&(l?n[1]<s[1]||n[1]===s[1]&&n[2]<=s[2]:n[1]>s[1]||n[1]===s[1]&&n[2]>=s[2]);case"number":case"range":return l?!isNaN(e)&&parseFloat(e)<=parseFloat(r):!isNaN(e)&&parseFloat(e)>=parseFloat(r);default:return l?e<=r:r<=e}}}function h(i,a,n){i.isValidating(!0);function e(e){var t=!1,r="";i.__valid__()&&(e.message?(t=e.isValid,r=e.message):t=e,t||(i.error(c.formatMessage(r||n.message||a.message,p(n.params),i)),i.__valid__(t))),i.isValidating(!1)}c.utils.async(function(){a.validator(i(),void 0===n.params||p(n.params),e)})}u(f.validation,g),c.rules={},c.rules.required={validator:function(e,t){var r;return null==e?!t:("string"==typeof(r=e)&&(r=String.prototype.trim?e.trim():e.replace(/^\s+|\s+$/g,"")),!t||0<(r+"").length)},message:"This field is required."},c.rules.min={validator:y("min"),message:"Please enter a value greater than or equal to {0}."},c.rules.max={validator:y("max"),message:"Please enter a value less than or equal to {0}."},c.rules.minLength={validator:function(e,t){return!!c.utils.isEmptyVal(e)||(c.utils.isNumber(e)?""+e:e).length>=t},message:"Please enter at least {0} characters."},c.rules.maxLength={validator:function(e,t){return!!c.utils.isEmptyVal(e)||(c.utils.isNumber(e)?""+e:e).length<=t},message:"Please enter no more than {0} characters."},c.rules.pattern={validator:function(e,t){return c.utils.isEmptyVal(e)||null!==e.toString().match(t)},message:"Please check this value."},c.rules.step={validator:function(e,t){if(c.utils.isEmptyVal(e)||"any"===t)return!0;var r=100*e%(100*t);return Math.abs(r)<1e-5||Math.abs(1-r)<1e-5},message:"The value must increment by {0}."},c.rules.email={validator:function(e,t){return!t||(c.utils.isEmptyVal(e)||t&&/^((([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+(\.([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+)*)|((\x22)((((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(([\x01-\x08\x0b\x0c\x0e-\x1f\x7f]|\x21|[\x23-\x5b]|[\x5d-\x7e]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(\\([\x01-\x09\x0b\x0c\x0d-\x7f]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))))*(((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(\x22)))@((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))$/i.test(e))},message:"Please enter a proper email address."},c.rules.date={validator:function(e,t){return!t||(c.utils.isEmptyVal(e)||t&&!/Invalid|NaN/.test(new Date(e)))},message:"Please enter a proper date."},c.rules.dateISO={validator:function(e,t){return!t||(c.utils.isEmptyVal(e)||t&&/^\d{4}[-/](?:0?[1-9]|1[012])[-/](?:0?[1-9]|[12][0-9]|3[01])$/.test(e))},message:"Please enter a proper date."},c.rules.number={validator:function(e,t){return!t||(c.utils.isEmptyVal(e)||t&&/^-?(?:\d+|\d{1,3}(?:,\d{3})+)?(?:\.\d+)?$/.test(e))},message:"Please enter a number."},c.rules.digit={validator:function(e,t){return!t||(c.utils.isEmptyVal(e)||t&&/^\d+$/.test(e))},message:"Please enter a digit."},c.rules.phoneUS={validator:function(e,t){return!t||(!!c.utils.isEmptyVal(e)||"string"==typeof e&&(e=e.replace(/\s+/g,""),t&&9<e.length&&e.match(/^(1-?)?(\([2-9]\d{2}\)|[2-9]\d{2})-?[2-9]\d{2}-?\d{4}$/)))},message:"Please specify a valid phone number."},c.rules.equal={validator:function(e,t){var r=t;return e===c.utils.getValue(r)},message:"Values must equal."},c.rules.notEqual={validator:function(e,t){var r=t;return e!==c.utils.getValue(r)},message:"Please choose another value."},c.rules.unique={validator:function(t,r){var e=c.utils.getValue(r.collection),i=c.utils.getValue(r.externalValue),a=0;return!t||!e||(o.arrayFilter(e,function(e){t===(r.valueAccessor?r.valueAccessor(e):e)&&a++}),a<(i?1:2))},message:"Please make sure the value is unique."},c.registerExtenders(),f.bindingHandlers.validationCore={init:function(e,t,r,i,a){var n=c.utils.getConfigOptions(e),s=t();if(n.parseInputAttributes&&c.utils.async(function(){c.parseInputValidationAttributes(e,t)}),n.insertMessages&&c.utils.isValidatable(s)){var u=c.insertValidationMessage(e);n.messageTemplate?f.renderTemplate(n.messageTemplate,{field:s},null,u,"replaceNode"):f.applyBindingsToNode(u,{validationMessage:s})}n.writeInputAttributes&&c.utils.isValidatable(s)&&c.writeInputValidationAttributes(e,t),n.decorateInputElement&&c.utils.isValidatable(s)&&f.applyBindingsToNode(e,{validationElement:s})}},c.makeBindingHandlerValidatable("value"),c.makeBindingHandlerValidatable("checked"),f.bindingHandlers.textInput&&c.makeBindingHandlerValidatable("textInput"),c.makeBindingHandlerValidatable("selectedOptions"),f.bindingHandlers.validationMessage={update:function(e,t){var r,i,a=t(),n=c.utils.getConfigOptions(e);p(a);if(null==a)throw new Error("Cannot bind validationMessage to undefined value. data-bind expression: "+e.getAttribute("data-bind"));r=a.isModified&&a.isModified(),i=a.isValid&&a.isValid();var s=null;n.messagesOnModified&&!r||(s=i?null:a.error);var u=!(n.messagesOnModified&&!r)&&!i,l="none"!==e.style.display;n.allowHtmlMessages?o.setHtml(e,s):f.bindingHandlers.text.update(e,function(){return s}),l&&!u?e.style.display="none":!l&&u&&(e.style.display="")}},f.bindingHandlers.validationElement={update:function(r,e,t){var i,a,n=e(),s=c.utils.getConfigOptions(r);p(n);if(null==n)throw new Error("Cannot bind validationElement to undefined value. data-bind expression: "+r.getAttribute("data-bind"));i=n.isModified&&n.isModified(),a=n.isValid&&n.isValid();f.bindingHandlers.css.update(r,function(){var e={},t=!(s.decorateElementOnModified&&!i)&&!a;return e[s.errorElementClass]=t,e},t),s.errorsAsTitle&&f.bindingHandlers.attr.update(r,function(){var e=!s.errorsAsTitleOnModified||i,t=c.utils.getOriginalElementTitle(r);return e&&!a?{title:n.error,"data-orig-title":t}:!e||a?{title:t,"data-orig-title":null}:void 0})}},f.bindingHandlers.validationOptions={init:function(e,t,r,i,a){var n=p(t());if(n){var s=u({},c.configuration);u(s,n),c.utils.setDomData(e,s)}}},f.extenders.validation=function(t,e){return n(c.utils.isArray(e)?e:[e],function(e){c.addAnonymousRule(t,e)}),t},f.extenders.validatable=function(i,e){if(c.utils.isObject(e)||(e={enable:e}),"enable"in e||(e.enable=!0),e.enable&&!c.utils.isValidatable(i)){var t=c.configuration.validate||{},r={throttleEvaluation:e.throttle||t.throttle};i.error=f.observable(null),i.rules=f.observableArray(),i.isValidating=f.observable(!1),i.__valid__=f.observable(!0),i.isModified=f.observable(!1),i.isValid=f.computed(i.__valid__),i.setError=function(e){var t=i.error.peek(),r=i.__valid__.peek();i.error(e),i.__valid__(!1),t===e||r||i.isValid.notifySubscribers()},i.clearError=function(){return i.error(null),i.__valid__(!0),i};var a=i.subscribe(function(){i.isModified(!0)}),n=f.computed(u({read:function(){i(),i.rules();return c.validateObservable(i),!0}},r));u(n,r),i._disposeValidation=function(){i.isValid.dispose(),i.rules.removeAll(),a.dispose(),n.dispose(),delete i.rules,delete i.error,delete i.isValid,delete i.isValidating,delete i.__valid__,delete i.isModified,delete i.setError,delete i.clearError,delete i._disposeValidation}}else!1===e.enable&&i._disposeValidation&&i._disposeValidation();return i},c.validateObservable=function(e){for(var t,r,i,a,n,s=0,u=e.rules(),l=u.length;s<l;s++)if(!(r=u[s]).condition||r.condition())if((t=r.rule?c.rules[r.rule]:r).async||r.async)h(e,t,r);else if(i=e,n=r,!(a=t).validator(i(),void 0===n.params||p(n.params))&&(i.setError(c.formatMessage(n.message||a.message,p(n.params),i)),1))return!1;return e.clearError(),!0};var x,E={};c.defineLocale=function(e,t){return e&&t?E[e.toLowerCase()]=t:null},c.locale=function(e){if(e){if(e=e.toLowerCase(),!E.hasOwnProperty(e))throw new Error("Localization "+e+" has not been loaded.");c.localize(E[e]),x=e}return x},c.localize=function(e){var t=c.rules;for(var r in e)t.hasOwnProperty(r)&&(t[r].message=e[r])},function(){var e={},t=c.rules;for(var r in t)t.hasOwnProperty(r)&&(e[r]=t[r].message);c.defineLocale("en-us",e)}(),x="en-us",f.applyBindingsWithValidation=function(e,t,r){var i,a=document.body;i=t&&t.nodeType?(a=t,r):t,c.init(),i&&(i=u(u({},c.configuration),i),c.utils.setDomData(a,i)),f.applyBindings(e,a)};var A=f.applyBindings;f.applyBindings=function(){c.init(),A.apply(this,arguments)},f.validatedObservable=function(e,t){if(!t&&!c.utils.isObject(e))return f.observable(e).extend({validatable:!0});var r=f.observable(e);return r.errors=c.group(c.utils.isObject(e)?e:{},t),r.isValid=f.observable(0===r.errors().length),f.isObservable(r.errors)?r.errors.subscribe(function(e){r.isValid(0===e.length)}):f.computed(r.errors).subscribe(function(e){r.isValid(0===e.length)}),r.subscribe(function(e){c.utils.isObject(e)||(e={}),r.errors._updateState(e),r.isValid(0===r.errors().length)}),r}});
//# sourceMappingURL=knockout.validation.min.js.map